/*
 * Decompiled with CFR 0.152.
 */
package minechem;

import cpw.mods.fml.common.registry.GameRegistry;
import minechem.fluid.FluidHelper;
import minechem.item.ItemAtomicManipulator;
import minechem.item.OpticalMicroscopeLens;
import minechem.item.blueprint.ItemBlueprint;
import minechem.item.chemistjournal.ChemistJournalItem;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.item.polytool.PolytoolItem;
import minechem.utils.MinechemFuelHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MinechemItemsRegistration {
    public static ElementItem element;
    public static MoleculeItem molecule;
    public static OpticalMicroscopeLens lens;
    public static ItemAtomicManipulator atomicManipulator;
    public static ItemBlueprint blueprint;
    public static ChemistJournalItem journal;
    public static ItemStack convexLens;
    public static ItemStack concaveLens;
    public static ItemStack projectorLens;
    public static ItemStack microscopeLens;
    public static ItemStack minechempills;
    public static Item polytool;
    public static ItemStack emptyTube;

    public static void init() {
        element = new ElementItem();
        GameRegistry.registerItem((Item)element, (String)"minechemElement");
        molecule = new MoleculeItem();
        GameRegistry.registerItem((Item)molecule, (String)"minechemMolecule");
        lens = new OpticalMicroscopeLens();
        concaveLens = new ItemStack((Item)lens, 1, 0);
        convexLens = new ItemStack((Item)lens, 1, 1);
        microscopeLens = new ItemStack((Item)lens, 1, 2);
        projectorLens = new ItemStack((Item)lens, 1, 3);
        GameRegistry.registerItem((Item)lens, (String)"minechemOpticalMicroscopeLens");
        atomicManipulator = new ItemAtomicManipulator();
        GameRegistry.registerItem((Item)atomicManipulator, (String)"minechemAtomicManipulator");
        blueprint = new ItemBlueprint();
        GameRegistry.registerItem((Item)blueprint, (String)"minechemBlueprint");
        journal = new ChemistJournalItem();
        GameRegistry.registerItem((Item)journal, (String)"minechemJournal");
        polytool = new PolytoolItem();
        GameRegistry.registerItem((Item)polytool, (String)"minechemPolytool");
        emptyTube = new ItemStack((Item)element, 1, 0);
    }

    public static void registerFluidContainers() {
        ItemStack tube;
        for (ElementEnum element : ElementEnum.elements.values()) {
            if (element == null) continue;
            tube = new ItemStack((Item)MinechemItemsRegistration.element, 1, element.atomicNumber());
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack((Fluid)FluidHelper.elements.get(element), 125), (ItemStack)tube, (ItemStack)emptyTube);
        }
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            tube = new ItemStack((Item)MinechemItemsRegistration.molecule, 1, molecule.id());
            FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 125);
            if (!molecule.name().equals("water")) {
                fluidStack = new FluidStack((Fluid)FluidHelper.molecules.get(molecule), 125);
            }
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)tube, (ItemStack)emptyTube);
        }
    }

    public static void registerToOreDictionary() {
        for (ElementEnum element : ElementEnum.elements.values()) {
            OreDictionary.registerOre((String)("element_" + element.name()), (ItemStack)new ItemStack((Item)MinechemItemsRegistration.element, 1, element.atomicNumber()));
        }
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            OreDictionary.registerOre((String)("molecule_" + molecule.name()), (ItemStack)new ItemStack((Item)MinechemItemsRegistration.molecule, 1, molecule.id()));
        }
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack((Item)molecule, 1, MoleculeEnum.potassiumNitrate.id()));
        OreDictionary.registerOre((String)"dustSalt", (ItemStack)new ItemStack((Item)molecule, 1, MoleculeEnum.salt.id()));
        OreDictionary.registerOre((String)"quicksilver", (ItemStack)new ItemStack((Item)element, 1, ElementEnum.Hg.atomicNumber()));
    }

    public static void addDungeonLoot() {
        ChestGenHooks ChestProvider = ChestGenHooks.getInfo((String)"dungeonChest");
        ItemStack A = new ItemStack((Item)blueprint, 1, 0);
        ItemStack B = new ItemStack((Item)blueprint, 1, 1);
        ChestProvider.addItem(new WeightedRandomChestContent(A, 10, 80, 1));
        ChestProvider.addItem(new WeightedRandomChestContent(B, 10, 80, 1));
    }

    public static void registerFuelValues() {
        MinechemFuelHandler.addFuel(new ItemStack((Item)element, 1, ElementEnum.C.atomicNumber()), 200);
        MinechemFuelHandler.addFuel(new ItemStack((Item)element, 1, ElementEnum.H.atomicNumber()), 100);
        MinechemFuelHandler.addFuel(new ItemStack((Item)element, 1, ElementEnum.S.atomicNumber()), 300);
        MinechemFuelHandler.addFuel(new ItemStack((Item)element, 1, ElementEnum.P.atomicNumber()), 250);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.cellulose.id()), 65);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.meoh.id()), 500);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.ethanol.id()), 1100);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.aalc.id()), 800);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.propane.id()), 1400);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.toluene.id()), 2200);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.tnt.id()), 4000);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.isoprene.id()), 1800);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.butene.id()), 1600);
        MinechemFuelHandler.addFuel(new ItemStack((Item)molecule, 1, MoleculeEnum.memethacrylate.id()), 5700);
    }
}

