/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import java.awt.Color;
import minechem.MinechemItemsRegistration;
import minechem.fluid.MinechemFluid;
import minechem.item.MinechemChemicalType;
import minechem.item.molecule.MoleculeEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FluidMolecule
extends MinechemFluid {
    public final MoleculeEnum molecule;
    private final int color;

    public FluidMolecule(MoleculeEnum molecule) {
        super("molecule." + molecule.name(), molecule.roomState());
        this.molecule = molecule;
        this.color = this.computeColor();
    }

    @Override
    public ItemStack getOutputStack() {
        return new ItemStack((Item)MinechemItemsRegistration.molecule, 1, this.molecule.id());
    }

    @Override
    public MinechemChemicalType getChemical() {
        return this.molecule;
    }

    public int getColor() {
        return this.color;
    }

    private int computeColor() {
        int red = (int)(this.molecule.red * 255.0f);
        int green = (int)(this.molecule.green * 255.0f);
        int blue = (int)(this.molecule.blue * 255.0f);
        return new Color(red, green, blue).getRGB();
    }
}

