/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import cpw.mods.fml.common.network.IGuiHandler;
import minechem.gui.GuiTableOfElements;
import minechem.item.chemistjournal.ChemistJournalContainer;
import minechem.item.chemistjournal.ChemistJournalGui;
import minechem.item.polytool.PolytoolContainer;
import minechem.item.polytool.PolytoolGui;
import minechem.tileentity.blueprintprojector.BlueprintProjectorContainer;
import minechem.tileentity.blueprintprojector.BlueprintProjectorGui;
import minechem.tileentity.blueprintprojector.BlueprintProjectorTileEntity;
import minechem.tileentity.decomposer.DecomposerContainer;
import minechem.tileentity.decomposer.DecomposerGui;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import minechem.tileentity.leadedchest.LeadedChestContainer;
import minechem.tileentity.leadedchest.LeadedChestGui;
import minechem.tileentity.leadedchest.LeadedChestTileEntity;
import minechem.tileentity.microscope.MicroscopeContainer;
import minechem.tileentity.microscope.MicroscopeGui;
import minechem.tileentity.microscope.MicroscopeTileEntity;
import minechem.tileentity.multiblock.fission.FissionContainer;
import minechem.tileentity.multiblock.fission.FissionGui;
import minechem.tileentity.multiblock.fission.FissionTileEntity;
import minechem.tileentity.multiblock.fusion.FusionContainer;
import minechem.tileentity.multiblock.fusion.FusionGui;
import minechem.tileentity.multiblock.fusion.FusionTileEntity;
import minechem.tileentity.prefab.TileEntityProxy;
import minechem.tileentity.synthesis.SynthesisContainer;
import minechem.tileentity.synthesis.SynthesisGui;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public static final int GUI_ID_TILEENTITY = 0;
    public static final int GUI_ID_JOURNAL = 1;
    public static final int GUI_TABLE = 2;
    public static final int GUI_ID_POLYTOOL = 3;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 1) {
            return this.getServerGuiElementForJournal(player, world);
        }
        if (ID == 3) {
            return this.getServerGuiElementForPolytool(player, world);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof DecomposerTileEntity) {
            return new DecomposerContainer(player.field_71071_by, (DecomposerTileEntity)tileEntity);
        }
        if (tileEntity instanceof LeadedChestTileEntity) {
            return new LeadedChestContainer(player.field_71071_by, (LeadedChestTileEntity)tileEntity);
        }
        if (tileEntity instanceof MicroscopeTileEntity) {
            return new MicroscopeContainer(player.field_71071_by, (MicroscopeTileEntity)tileEntity);
        }
        if (tileEntity instanceof SynthesisTileEntity) {
            return new SynthesisContainer(player.field_71071_by, (SynthesisTileEntity)tileEntity);
        }
        if (tileEntity instanceof FusionTileEntity) {
            return new FusionContainer(player.field_71071_by, (FusionTileEntity)tileEntity);
        }
        if (tileEntity instanceof FissionTileEntity) {
            return new FissionContainer(player.field_71071_by, (FissionTileEntity)tileEntity);
        }
        if (tileEntity instanceof TileEntityProxy) {
            return this.getServerGuiElementFromProxy((TileEntityProxy)tileEntity, player);
        }
        if (tileEntity instanceof BlueprintProjectorTileEntity) {
            return new BlueprintProjectorContainer(player.field_71071_by, (BlueprintProjectorTileEntity)tileEntity);
        }
        return null;
    }

    private Object getServerGuiElementForPolytool(EntityPlayer player, World world) {
        return new PolytoolContainer(player);
    }

    public Object getServerGuiElementFromProxy(TileEntityProxy proxy, EntityPlayer player) {
        TileEntity tileEntity = proxy.getManager();
        if (tileEntity instanceof FusionTileEntity) {
            return new FusionContainer(player.field_71071_by, (FusionTileEntity)tileEntity);
        }
        if (tileEntity instanceof FissionTileEntity) {
            return new FissionContainer(player.field_71071_by, (FissionTileEntity)tileEntity);
        }
        return null;
    }

    public Object getServerGuiElementForJournal(EntityPlayer entityPlayer, World world) {
        return new ChemistJournalContainer(entityPlayer.field_71071_by);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 1) {
            return this.getClientGuiElementForJournal(player, world);
        }
        if (ID == 2) {
            return this.getClientGuiForJournal(player, world);
        }
        if (ID == 3) {
            return this.getClientGuiForPolytool(player, world);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof DecomposerTileEntity) {
            return new DecomposerGui(player.field_71071_by, (DecomposerTileEntity)tileEntity);
        }
        if (tileEntity instanceof LeadedChestTileEntity) {
            return new LeadedChestGui(player.field_71071_by, (LeadedChestTileEntity)tileEntity);
        }
        if (tileEntity instanceof MicroscopeTileEntity) {
            return new MicroscopeGui(player.field_71071_by, (MicroscopeTileEntity)tileEntity);
        }
        if (tileEntity instanceof SynthesisTileEntity) {
            return new SynthesisGui(player.field_71071_by, (SynthesisTileEntity)tileEntity);
        }
        if (tileEntity instanceof FusionTileEntity) {
            return new FusionGui(player.field_71071_by, (FusionTileEntity)tileEntity);
        }
        if (tileEntity instanceof TileEntityProxy) {
            return this.getClientGuiElementFromProxy((TileEntityProxy)tileEntity, player);
        }
        if (tileEntity instanceof BlueprintProjectorTileEntity) {
            return new BlueprintProjectorGui(player.field_71071_by, (BlueprintProjectorTileEntity)tileEntity);
        }
        if (tileEntity instanceof FissionTileEntity) {
            return new FissionGui(player.field_71071_by, (FissionTileEntity)tileEntity);
        }
        return null;
    }

    private PolytoolGui getClientGuiForPolytool(EntityPlayer player, World world) {
        return new PolytoolGui(new PolytoolContainer(player));
    }

    public Object getClientGuiElementFromProxy(TileEntityProxy proxy, EntityPlayer player) {
        TileEntity tileEntity = proxy.getManager();
        if (tileEntity instanceof FusionTileEntity) {
            return new FusionGui(player.field_71071_by, (FusionTileEntity)tileEntity);
        }
        if (tileEntity instanceof FissionTileEntity) {
            return new FissionGui(player.field_71071_by, (FissionTileEntity)tileEntity);
        }
        return null;
    }

    public Object getClientGuiElementForJournal(EntityPlayer player, World world) {
        return new ChemistJournalGui(player);
    }

    public Object getClientGuiForJournal(EntityPlayer player, World world) {
        return new GuiTableOfElements(player);
    }
}

