/*
 * Decompiled with CFR 0.152.
 */
package minechem.radiation;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minechem.MinechemItemsRegistration;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.fluid.FluidHelper;
import minechem.item.MinechemChemicalType;
import minechem.item.bucket.MinechemBucketHandler;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.MoleculeItem;
import minechem.radiation.RadiationDecayEvent;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationInfo;
import minechem.radiation.RadiationMoleculeHandler;
import minechem.utils.MinechemUtil;
import minechem.utils.TimeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class RadiationHandler {
    private static RadiationHandler instance = new RadiationHandler();

    public static RadiationHandler getInstance() {
        return instance == null ? new RadiationHandler() : instance;
    }

    public RadiationHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void update(EntityPlayer player) {
        Container openContainer = player.field_71070_bA;
        if (openContainer != null) {
            if (openContainer instanceof INoDecay) {
                this.updateContainerNoDecay(player, openContainer, (IInventory)player.field_71071_by);
            } else {
                this.updateContainer(player, openContainer, (IInventory)player.field_71071_by);
            }
        } else {
            this.updateContainer(player, player.field_71069_bz, (IInventory)player.field_71071_by);
        }
    }

    private void updateContainerNoDecay(EntityPlayer player, Container openContainer, IInventory inventory) {
        List<ItemStack> playerStacks;
        INoDecay container = (INoDecay)openContainer;
        List<ItemStack> itemstacks = container.getStorageInventory();
        if (itemstacks != null) {
            for (ItemStack itemstack : itemstacks) {
                if (itemstack == null || itemstack.func_77973_b() != MinechemItemsRegistration.molecule && itemstack.func_77973_b() != MinechemItemsRegistration.element && !(itemstack.func_77973_b() instanceof MinechemBucketItem) || RadiationInfo.getRadioactivity(itemstack) == RadiationEnum.stable) continue;
                RadiationInfo radiationInfo = ElementItem.getRadiationInfo(itemstack, player.field_70170_p);
                radiationInfo.decayStarted += player.field_70170_p.func_82737_E() - radiationInfo.lastDecayUpdate;
                radiationInfo.lastDecayUpdate = player.field_70170_p.func_82737_E();
                RadiationInfo.setRadiationInfo(radiationInfo, itemstack);
            }
        }
        if ((playerStacks = container.getPlayerInventory()) != null) {
            this.updateRadiationOnItems(player.field_70170_p, player, openContainer, inventory, playerStacks);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void updateRadiationOnItems(World world, ITurtleAccess turtle, IInventory inventory, List<ItemStack> itemstacks) {
        this.updateRadiationOnItems(world, inventory, itemstacks, null, null, turtle.getPosition().field_71574_a, turtle.getPosition().field_71572_b, turtle.getPosition().field_71573_c);
    }

    private void updateContainer(EntityPlayer player, Container container, IInventory inventory) {
        List itemstacks = container.func_75138_a();
        this.updateRadiationOnItems(player.field_70170_p, player, container, inventory, itemstacks);
    }

    private void updateRadiationOnItems(World world, EntityPlayer player, Container container, IInventory inventory, List<ItemStack> itemstacks) {
        this.updateRadiationOnItems(world, inventory, itemstacks, player, container, player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    private void updateRadiationOnItems(World world, IInventory inventory, List<ItemStack> itemstacks, EntityPlayer player, Container container, double posX, double posY, double posZ) {
        for (int i = 0; i < itemstacks.size(); ++i) {
            ItemStack itemstack = itemstacks.get(i);
            if (itemstack == null) continue;
            RadiationEnum radiation = null;
            Item item = itemstack.func_77973_b();
            if (item == MinechemItemsRegistration.element) {
                radiation = RadiationInfo.getRadioactivity(itemstack);
            } else if (item == MinechemItemsRegistration.molecule) {
                radiation = MoleculeItem.getMolecule(itemstack).radioactivity();
            } else if (item instanceof MinechemBucketItem) {
                radiation = ((MinechemBucketItem)item).chemical.radioactivity();
            }
            if (radiation == null || radiation == RadiationEnum.stable) continue;
            Long time = world.func_82737_E() - ElementItem.getRadiationInfo((ItemStack)itemstack, (World)world).decayStarted;
            ItemStack before = itemstack.func_77946_l();
            int damage = this.updateRadiation(world, itemstack, inventory, posX, posY, posZ);
            ItemStack after = itemstack.func_77946_l();
            if (damage <= 0) continue;
            IInventory decayInventory = container == null ? inventory : container.func_75139_a((int)i).field_75224_c;
            MinecraftForge.EVENT_BUS.post((Event)new RadiationDecayEvent(decayInventory, damage, time, before, after, player));
            if (container == null || player == null) continue;
            this.applyRadiationDamage(player, container, damage);
        }
    }

    private void applyRadiationDamage(EntityPlayer player, Container container, int damage) {
        ArrayList<Float> reductions = new ArrayList<Float>();
        if (container instanceof IRadiationShield) {
            float reduction = ((IRadiationShield)container).getRadiationReductionFactor(damage, null, player);
            reductions.add(Float.valueOf(reduction));
        }
        for (ItemStack armour : player.field_71071_by.field_70460_b) {
            if (armour == null || !(armour.func_77973_b() instanceof IRadiationShield)) continue;
            float reduction = ((IRadiationShield)armour.func_77973_b()).getRadiationReductionFactor(damage, armour, player);
            reductions.add(Float.valueOf(reduction));
        }
        float totalReductionFactor = 1.0f;
        Iterator i$ = reductions.iterator();
        while (i$.hasNext()) {
            float reduction = ((Float)i$.next()).floatValue();
            totalReductionFactor -= reduction;
        }
        if (totalReductionFactor < 0.0f) {
            totalReductionFactor = 0.0f;
        }
        damage = Math.round((float)damage * totalReductionFactor);
        player.func_70097_a(DamageSource.field_76377_j, (float)damage);
    }

    @SubscribeEvent
    public void onDecayEvent(RadiationDecayEvent e) {
        if (e.getPlayer() != null) {
            String nameBeforeDecay = this.getLongName(e.getBefore());
            String nameAfterDecay = this.getLongName(e.getAfter());
            String time = TimeHelper.getTimeFromTicks(e.getTime());
            String message = String.format("Radiation Warning: Element %s decayed into %s after %s.", nameBeforeDecay, nameAfterDecay, time);
            e.getPlayer().func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    private String getLongName(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == MinechemItemsRegistration.element) {
            return ElementItem.getLongName(stack);
        }
        if (item == MinechemItemsRegistration.molecule) {
            return MinechemUtil.getLocalString(MoleculeItem.getMolecule(stack).getUnlocalizedName(), true);
        }
        return "null";
    }

    private int updateRadiation(World world, ItemStack element, IInventory inventory, double x, double y, double z) {
        RadiationInfo radiationInfo = ElementItem.getRadiationInfo(element, world);
        int dimensionID = world.field_73011_w.field_76574_g;
        if (dimensionID != radiationInfo.dimensionID && radiationInfo.isRadioactive()) {
            radiationInfo.dimensionID = dimensionID;
            RadiationInfo.setRadiationInfo(radiationInfo, element);
            return 0;
        }
        long currentTime = world.func_82737_E();
        return this.decayElement(element, radiationInfo, currentTime, world, inventory, x, y, z);
    }

    private int decayElement(ItemStack element, RadiationInfo radiationInfo, long currentTime, World world, IInventory inventory, double x, double y, double z) {
        if (element.field_77994_a == 0) {
            radiationInfo.decayStarted += currentTime - radiationInfo.lastDecayUpdate;
            radiationInfo.lastDecayUpdate = currentTime;
            RadiationInfo.setRadiationInfo(radiationInfo, element);
            return 0;
        }
        radiationInfo.lastDecayUpdate = currentTime;
        long lifeTime = currentTime - radiationInfo.decayStarted - radiationInfo.radioactivity.getLife();
        if (lifeTime > 0L) {
            int damage = radiationInfo.radioactivity.getDamage() * element.field_77994_a;
            Item item = element.func_77973_b();
            if (item == MinechemItemsRegistration.element) {
                radiationInfo = ElementItem.decay(element, world);
            } else if (item == MinechemItemsRegistration.molecule) {
                radiationInfo = RadiationMoleculeHandler.getInstance().handleRadiationMolecule(world, element, inventory, x, y, z);
            } else if (item instanceof MinechemBucketItem) {
                MinechemChemicalType type = ((MinechemBucketItem)item).chemical;
                if (type instanceof ElementEnum) {
                    element.func_150996_a((Item)MinechemBucketHandler.getInstance().buckets.get((Object)FluidHelper.elementsBlocks.get((Object)FluidHelper.elements.get(ElementEnum.getByID(((ElementEnum)type).atomicNumber())))));
                    radiationInfo = ElementItem.initiateRadioactivity(element, world);
                } else {
                    radiationInfo = RadiationMoleculeHandler.getInstance().handleRadiationMoleculeBucket(world, element, inventory, x, y, z);
                }
            }
            RadiationInfo.setRadiationInfo(radiationInfo, element);
            return damage;
        }
        RadiationInfo.setRadiationInfo(radiationInfo, element);
        return 0;
    }
}

