/*
 * Decompiled with CFR 0.152.
 */
package minechem.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FontRendererWithZLevel
implements IResourceManagerReloadListener {
    private static FontRendererWithZLevel fontRendererWithZLevel;
    private float zLevel = 0.0f;
    private final ResourceLocation locationFontTexture;
    private int[] charWidth = new int[256];
    public int FONT_HEIGHT = 9;
    public Random fontRandom = new Random();
    private byte[] glyphWidth = new byte[65536];
    private int[] colorCode = new int[32];
    private final TextureManager renderEngine;
    private float posX;
    private float posY;
    private boolean unicodeFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private boolean randomStyle;
    private boolean boldStyle;
    private boolean italicStyle;
    private boolean underlineStyle;
    private boolean strikethroughStyle;

    public static FontRendererWithZLevel getFontRenderer(float zLevel) {
        if (fontRendererWithZLevel == null) {
            fontRendererWithZLevel = new FontRendererWithZLevel();
        }
        return fontRendererWithZLevel.setZLevel(zLevel);
    }

    public FontRendererWithZLevel setZLevel(float zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    private FontRendererWithZLevel() {
        this.locationFontTexture = new ResourceLocation("textures/font/ascii.png");
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.unicodeFlag = false;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.locationFontTexture);
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
                int k1 = (k * 30 + l * 70) / 100;
                int l1 = (k * 30 + i1 * 70) / 100;
                k = j1;
                l = k1;
                i1 = l1;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            this.colorCode[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        this.readGlyphSizes();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        this.readFontTexture();
    }

    private void readFontTexture() {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.locationFontTexture).func_110527_b());
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        int k = j / 16;
        int l = i / 16;
        int b0 = 1;
        float f = 8.0f / (float)l;
        for (int i1 = 0; i1 < 256; ++i1) {
            int l1;
            int j1 = i1 % 16;
            int k1 = i1 / 16;
            if (i1 == 32) {
                this.charWidth[i1] = 3 + b0;
            }
            for (l1 = l - 1; l1 >= 0; --l1) {
                int i2 = j1 * l + l1;
                boolean flag = true;
                for (int j2 = 0; j2 < k && flag; ++j2) {
                    int k2 = (k1 * l + j2) * i;
                    if ((aint[i2 + k2] >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            this.charWidth[i1] = (int)(0.5 + (double)((float)(++l1) * f)) + b0;
        }
    }

    private void readGlyphSizes() {
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            inputstream.read(this.glyphWidth);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
    }

    private float renderCharAtPos(int p_78278_1_, char p_78278_2_, boolean p_78278_3_) {
        return p_78278_2_ == ' ' ? 4.0f : this.renderDefaultChar(p_78278_1_, p_78278_3_);
    }

    private float renderDefaultChar(int p_78266_1_, boolean p_78266_2_) {
        float f = p_78266_1_ % 16 * 8;
        float f1 = p_78266_1_ / 16 * 8;
        float f2 = p_78266_2_ ? 1.0f : 0.0f;
        this.renderEngine.func_110577_a(this.locationFontTexture);
        float f3 = (float)this.charWidth[p_78266_1_] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f2), (float)this.posY, (float)this.zLevel);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX - f2), (float)(this.posY + 7.99f), (float)this.zLevel);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f + f2), (float)this.posY, (float)this.zLevel);
        GL11.glTexCoord2f((float)((f + f3 - 1.0f) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.posX + f3 - 1.0f - f2), (float)(this.posY + 7.99f), (float)this.zLevel);
        GL11.glEnd();
        return this.charWidth[p_78266_1_];
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    public int drawString(String p_78276_1_, int p_78276_2_, int p_78276_3_, int p_78276_4_) {
        return this.drawString(p_78276_1_, p_78276_2_, p_78276_3_, p_78276_4_, false);
    }

    public int drawString(String p_85187_1_, int p_85187_2_, int p_85187_3_, int p_85187_4_, boolean p_85187_5_) {
        int l;
        GL11.glEnable((int)3008);
        this.resetStyles();
        if (p_85187_5_) {
            l = this.renderString(p_85187_1_, p_85187_2_ + 1, p_85187_3_ + 1, p_85187_4_, true);
            l = Math.max(l, this.renderString(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false));
        } else {
            l = this.renderString(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false);
        }
        return l;
    }

    private void renderStringAtPos(String p_78255_1_, boolean p_78255_2_) {
        for (int i = 0; i < p_78255_1_.length(); ++i) {
            Tessellator tessellator;
            boolean flag1;
            int k;
            int j;
            char c0 = p_78255_1_.charAt(i);
            if (c0 == '\u00a7' && i + 1 < p_78255_1_.length()) {
                j = "0123456789abcdefklmnor".indexOf(p_78255_1_.toLowerCase().charAt(i + 1));
                if (j < 16) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    if (j < 0 || j > 15) {
                        j = 15;
                    }
                    if (p_78255_2_) {
                        j += 16;
                    }
                    k = this.colorCode[j];
                    GL11.glColor4f((float)((float)(k >> 16) / 255.0f), (float)((float)(k >> 8 & 0xFF) / 255.0f), (float)((float)(k & 0xFF) / 255.0f), (float)this.alpha);
                } else if (j == 16) {
                    this.randomStyle = true;
                } else if (j == 17) {
                    this.boldStyle = true;
                } else if (j == 18) {
                    this.strikethroughStyle = true;
                } else if (j == 19) {
                    this.underlineStyle = true;
                } else if (j == 20) {
                    this.italicStyle = true;
                } else if (j == 21) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
                }
                ++i;
                continue;
            }
            j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.randomStyle && j != -1) {
                while (this.charWidth[j] != this.charWidth[k = this.fontRandom.nextInt(this.charWidth.length)]) {
                }
                j = k;
            }
            float f1 = this.unicodeFlag ? 0.5f : 1.0f;
            boolean bl = flag1 = (c0 == '\u0000' || j == -1 || this.unicodeFlag) && p_78255_2_;
            if (flag1) {
                this.posX -= f1;
                this.posY -= f1;
            }
            float f = this.renderCharAtPos(j, c0, this.italicStyle);
            if (flag1) {
                this.posX += f1;
                this.posY += f1;
            }
            if (this.boldStyle) {
                this.posX += f1;
                if (flag1) {
                    this.posX -= f1;
                    this.posY -= f1;
                }
                this.renderCharAtPos(j, c0, this.italicStyle);
                this.posX -= f1;
                if (flag1) {
                    this.posX += f1;
                    this.posY += f1;
                }
                f += 1.0f;
            }
            if (this.strikethroughStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), (double)this.zLevel);
                tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), (double)this.zLevel);
                tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), (double)this.zLevel);
                tessellator.func_78377_a((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), (double)this.zLevel);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            if (this.underlineStyle) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                int l = this.underlineStyle ? -1 : 0;
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT), (double)this.zLevel);
                tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)this.FONT_HEIGHT), (double)this.zLevel);
                tessellator.func_78377_a((double)(this.posX + f), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), (double)this.zLevel);
                tessellator.func_78377_a((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), (double)this.zLevel);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.posX += (float)((int)f);
        }
    }

    private int renderString(String p_78258_1_, int p_78258_2_, int p_78258_3_, int p_78258_4_, boolean p_78258_5_) {
        if (p_78258_1_ == null) {
            return 0;
        }
        if ((p_78258_4_ & 0xFC000000) == 0) {
            p_78258_4_ |= 0xFF000000;
        }
        if (p_78258_5_) {
            p_78258_4_ = (p_78258_4_ & 0xFCFCFC) >> 2 | p_78258_4_ & 0xFF000000;
        }
        this.red = (float)(p_78258_4_ >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(p_78258_4_ >> 8 & 0xFF) / 255.0f;
        this.green = (float)(p_78258_4_ & 0xFF) / 255.0f;
        this.alpha = (float)(p_78258_4_ >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.red, (float)this.blue, (float)this.green, (float)this.alpha);
        this.posX = p_78258_2_;
        this.posY = p_78258_3_;
        this.renderStringAtPos(p_78258_1_, p_78258_5_);
        return (int)this.posX;
    }

    public int getStringWidth(String p_78256_1_) {
        if (p_78256_1_ == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < p_78256_1_.length(); ++j) {
            char c0 = p_78256_1_.charAt(j);
            int k = this.getCharWidth(c0);
            if (k < 0 && j < p_78256_1_.length() - 1) {
                if ((c0 = p_78256_1_.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag || k <= 0) continue;
            ++i;
        }
        return i;
    }

    public int getCharWidth(char p_78263_1_) {
        if (p_78263_1_ == '\u00a7') {
            return -1;
        }
        if (p_78263_1_ == ' ') {
            return 4;
        }
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(p_78263_1_);
        return this.charWidth[i];
    }
}

