/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DecomposerFluidRecipe
extends DecomposerRecipe {
    public FluidStack inputFluid;

    public DecomposerFluidRecipe(FluidStack fluid, PotionChemical ... chemicals) {
        super(chemicals);
        this.inputFluid = fluid;
    }

    public DecomposerFluidRecipe(String fluid, int amount, PotionChemical[] chemicals) {
        this(new FluidStack(FluidRegistry.getFluid((String)fluid), amount), chemicals);
    }

    public static void createAndAddFluidRecipeSafely(String fluid, int amount, PotionChemical ... chemicals) {
        if (FluidRegistry.isFluidRegistered((String)fluid)) {
            DecomposerRecipe.add(new DecomposerFluidRecipe(fluid, amount, chemicals));
        }
    }

    @Override
    public ItemStack getInput() {
        return new ItemStack(this.inputFluid.getFluid() != null ? this.inputFluid.getFluid().getBlock() : null, 1, 0);
    }

    @Override
    public ArrayList<PotionChemical> getOutput() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    @Override
    public ArrayList<PotionChemical> getOutputRaw() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    @Override
    public MapKey getKey() {
        return new MapKey(this.inputFluid);
    }
}

