/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.microscope;

import minechem.tileentity.microscope.MicroscopeContainer;
import minechem.tileentity.microscope.MicroscopeGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class MicroscopeRenderGUIItem
extends RenderItem {
    public MicroscopeContainer microscopeContainer;
    public InventoryPlayer inventoryPlayer;
    public MicroscopeGui microscopeGui;

    public MicroscopeRenderGUIItem(MicroscopeGui microscopeGui) {
        this.microscopeGui = microscopeGui;
        this.microscopeContainer = (MicroscopeContainer)microscopeGui.field_147002_h;
        this.inventoryPlayer = microscopeGui.inventoryPlayer;
    }

    private void setScissor(float x, float y, float w, float h) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledRes = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int scale = scaledRes.func_78325_e();
        x *= (float)scale;
        y *= (float)scale;
        w *= (float)scale;
        h *= (float)scale;
        float guiScaledWidth = this.microscopeGui.guiWidth * scale;
        float guiScaledHeight = this.microscopeGui.guiHeight * scale;
        float guiLeft = (float)(mc.field_71443_c / 2) - guiScaledWidth / 2.0f;
        float guiTop = (float)(mc.field_71440_d / 2) + guiScaledHeight / 2.0f;
        int scissorX = Math.round(guiLeft + x);
        int scissorY = Math.round(guiTop - h - y);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)scissorY, (int)((int)w), (int)((int)h));
    }

    private void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public void func_82406_b(FontRenderer fontRenderer, TextureManager textureManager, ItemStack itemStack, int x, int y) {
        int renderY;
        int renderX;
        if (itemStack == null) {
            return;
        }
        RenderHelper.func_74520_c();
        Slot slot = this.microscopeContainer.func_75139_a(0);
        if (slot.func_75211_c() != null) {
            GL11.glPushMatrix();
            this.setScissor(this.microscopeGui.eyepieceX, this.microscopeGui.eyepieceY, 52.0f, 52.0f);
            renderX = this.microscopeGui.getGuiLeft() + slot.field_75223_e;
            renderY = this.microscopeGui.getGuiTop() + slot.field_75221_f;
            GL11.glTranslatef((float)renderX, (float)renderY, (float)0.0f);
            GL11.glScalef((float)3.0f, (float)3.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)(-renderX) - 5.3f), (float)((float)(-renderY) - 5.3f), (float)2.0f);
            super.func_82406_b(fontRenderer, textureManager, slot.func_75211_c(), renderX, renderY);
            this.stopScissor();
            GL11.glPopMatrix();
        }
        if (itemStack == this.inventoryPlayer.func_70445_o() && this.microscopeGui.isMouseInMicroscope()) {
            GL11.glPushMatrix();
            this.setScissor(this.microscopeGui.eyepieceX, this.microscopeGui.eyepieceY, 52.0f, 52.0f);
            renderX = x;
            renderY = y;
            GL11.glTranslatef((float)renderX, (float)renderY, (float)0.0f);
            GL11.glScalef((float)3.0f, (float)3.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)(-renderX) - 5.3f), (float)((float)(-renderY) - 5.3f), (float)540.0f);
            super.func_82406_b(fontRenderer, textureManager, itemStack, renderX, renderY);
            this.stopScissor();
            GL11.glPopMatrix();
        }
    }
}

