/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock.fusion;

import minechem.gui.GuiTabStateControl;
import minechem.tileentity.multiblock.fusion.FusionTileEntity;
import net.minecraft.client.gui.Gui;

public class FusionTabStateControl
extends GuiTabStateControl {
    private int lastKnownEnergyCost = 0;

    public FusionTabStateControl(Gui gui, FusionTileEntity fusion) {
        super(gui);
        this.tileEntity = fusion;
        this.state = GuiTabStateControl.TabState.norecipe;
    }

    @Override
    public void update() {
        super.update();
        if (this.tileEntity instanceof FusionTileEntity) {
            if (this.tileEntity.inventory[0] != null && this.tileEntity.inventory[1] != null) {
                if (((FusionTileEntity)this.tileEntity).inputsCanBeFused()) {
                    this.lastKnownEnergyCost = this.tileEntity.getEnergyNeeded();
                    this.state = this.lastKnownEnergyCost <= this.tileEntity.getEnergyStored() ? (((FusionTileEntity)this.tileEntity).canOutput() ? GuiTabStateControl.TabState.powered : GuiTabStateControl.TabState.jammed) : GuiTabStateControl.TabState.unpowered;
                } else {
                    this.state = GuiTabStateControl.TabState.norecipe;
                }
            } else {
                this.state = GuiTabStateControl.TabState.norecipe;
            }
            this.overlayColor = this.state.color;
        }
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.state == GuiTabStateControl.TabState.unpowered && this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

