/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.prefab;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.Optional;
import minechem.Settings;
import minechem.tileentity.prefab.MinechemTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI|energy")
public abstract class MinechemTileEntityElectric
extends MinechemTileEntity
implements IEnergyReceiver {
    private static int MAX_ENERGY_RECEIVED = Settings.energyPacketSize;
    private int MAX_ENERGY_STORED;
    private int energyStored;
    protected int oldEnergyStored;

    public MinechemTileEntityElectric(int maxEnergy) {
        this.MAX_ENERGY_STORED = maxEnergy;
        this.energyStored = 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = maxReceive <= MAX_ENERGY_RECEIVED ? maxReceive : MAX_ENERGY_RECEIVED;
        int n = received = this.energyStored + received > this.MAX_ENERGY_STORED ? this.MAX_ENERGY_STORED - this.energyStored : received;
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public void syncEnergyValue(int syncAt) {
        if (this.getEnergyStored() > syncAt) {
            this.useEnergy(this.getEnergyStored() - syncAt);
        } else if (this.getEnergyStored() < syncAt) {
            this.receiveEnergy(syncAt - this.getEnergyStored(), false);
        }
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.MAX_ENERGY_STORED;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    public boolean useEnergy(int energy) {
        if (!Settings.powerUseEnabled) {
            return true;
        }
        if (this.energyStored - energy < 0) {
            return false;
        }
        if (this.energyStored - energy > this.MAX_ENERGY_STORED) {
            return false;
        }
        this.energyStored -= energy;
        return true;
    }

    public int getPowerRemainingScaled(double scale) {
        return (int)((double)this.energyStored * (scale / (double)this.MAX_ENERGY_STORED));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("energy", this.energyStored);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("energy");
    }

    public abstract int getEnergyNeeded();
}

