/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import cpw.mods.fml.common.IFuelHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import minechem.item.bucket.MinechemBucketItem;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;

public class MinechemFuelHandler
implements IFuelHandler {
    private static Map<MapKey, Integer> fuels = new LinkedHashMap<MapKey, Integer>();

    public int getBurnTime(ItemStack fuel) {
        Integer result = fuels.get(new MapKey(fuel));
        if (result == null) {
            return 0;
        }
        int mult = MinechemFuelHandler.isBucket(fuel) ? 8 : 1;
        return result * mult;
    }

    private static boolean isBucket(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof MinechemBucketItem;
    }

    public static int addFuel(ItemStack itemStack, int value) {
        if (value > 0) {
            Integer result = fuels.put(new MapKey(itemStack), value);
            return result != null ? result : 0;
        }
        return 0;
    }

    public static int removeFuel(ItemStack itemStack) {
        MapKey key = new MapKey(itemStack);
        if (fuels.containsKey(key)) {
            Integer result = fuels.remove(key);
            return result != null ? result : 0;
        }
        return 0;
    }
}

