/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.utils.LogHelper;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Recipe {
    public static Map<MapKey, Recipe> recipes = new LinkedHashMap<MapKey, Recipe>();
    public static Map<ItemStack, ItemStack> smelting;
    public ItemStack output;
    public ItemStack[] inStacks;
    private int depth;
    private static final int MAXDEPTH = 20;

    @Optional.Method(modid="RotaryCraft")
    public static List getRotaryRecipes() {
        try {
            boolean add;
            Class<?> worktable = Class.forName("Reika.RotaryCraft.Auxiliary.WorktableRecipes");
            Method instance = worktable.getMethod("getInstance", new Class[0]);
            Method list = worktable.getMethod("getRecipeListCopy", new Class[0]);
            Class<?> config = Class.forName("Reika.RotaryCraft.Registry.ConfigRegistry");
            Method state = config.getMethod("getState", new Class[0]);
            boolean bl = add = (Boolean)state.invoke(Enum.valueOf(config, "TABLEMACHINES"), new Object[0]) == false;
            if (add) {
                return (List)list.invoke(instance.invoke(null, new Object[0]), new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Optional.Method(modid="Railcraft")
    public static List getRailcraftRecipes() {
        try {
            Class<?> rollingMachine = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method instance = rollingMachine.getMethod("getInstance", new Class[0]);
            Method list = rollingMachine.getMethod("getRecipeList", new Class[0]);
            return (List)list.invoke(instance.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void init() {
        List add;
        Hashtable<MapKey, ArrayList<Recipe>> preCullRecipes = new Hashtable<MapKey, ArrayList<Recipe>>();
        recipes = new LinkedHashMap<MapKey, Recipe>();
        smelting = FurnaceRecipes.func_77602_a().func_77599_b();
        List craftingRecipes = CraftingManager.func_77594_a().func_77592_b();
        if (Loader.isModLoaded((String)"RotaryCraft") && (add = Recipe.getRotaryRecipes()) != null) {
            craftingRecipes.addAll(add);
        }
        if (Loader.isModLoaded((String)"Railcaft") && (add = Recipe.getRailcraftRecipes()) != null) {
            craftingRecipes.addAll(add);
        }
        for (Object e : craftingRecipes) {
            ItemStack input;
            if (!(e instanceof IRecipe) || Recipe.invalidStack(input = ((IRecipe)e).func_77571_b())) continue;
            LogHelper.debug("Adding recipe for " + input.toString());
            ItemStack[] components = null;
            ArrayList inputs = new ArrayList();
            if (e.getClass().equals(ShapelessOreRecipe.class) && ((ShapelessOreRecipe)e).getInput().size() > 0) {
                for (Object o : ((ShapelessOreRecipe)e).getInput()) {
                    if (!(o instanceof ItemStack)) continue;
                    inputs.add((ItemStack)o);
                }
            } else if (e.getClass().equals(ShapedOreRecipe.class)) {
                for (Object o : ((ShapedOreRecipe)e).getInput()) {
                    if (o instanceof ItemStack) {
                        inputs.add((ItemStack)o);
                        continue;
                    }
                    if (o instanceof String) {
                        inputs.add(OreDictionary.getOres((String)((String)o)).get(0));
                        continue;
                    }
                    if (!(o instanceof ArrayList) || ((ArrayList)o).isEmpty()) continue;
                    inputs.add((ItemStack)((ArrayList)o).get(0));
                }
            } else if (e.getClass().equals(ShapelessRecipes.class) && ((ShapelessRecipes)e).field_77579_b.toArray() instanceof ItemStack[]) {
                inputs = (ArrayList)((ShapelessRecipes)e).field_77579_b;
            } else if (e.getClass().equals(ShapedRecipes.class)) {
                inputs.addAll(Arrays.asList(((ShapedRecipes)e).field_77574_d));
            }
            MapKey key = MapKey.getKey(input);
            if (inputs.size() <= 0 || key == null) continue;
            Iterator itr = inputs.iterator();
            while (itr.hasNext()) {
                ItemStack component = (ItemStack)itr.next();
                if (!Recipe.invalidStack(component) && !component.func_77973_b().hasContainerItem(component)) continue;
                itr.remove();
            }
            components = inputs.toArray(new ItemStack[inputs.size()]);
            if (components.length <= 0) continue;
            Recipe addRecipe = new Recipe(input, components);
            Recipe.addPreCullRecipe(key, addRecipe, preCullRecipes);
        }
        for (ItemStack itemStack : smelting.keySet()) {
            MapKey key;
            ItemStack output = smelting.get(itemStack);
            if (Recipe.invalidStack(itemStack) || Recipe.invalidStack(output) || (key = MapKey.getKey(output)) == null) continue;
            Recipe addRecipe = new Recipe(output, new ItemStack[]{itemStack});
            LogHelper.debug("Adding Smelting recipe for " + output.toString());
            Recipe.addPreCullRecipe(key, addRecipe, preCullRecipes);
        }
        for (Map.Entry entry : preCullRecipes.entrySet()) {
            if (entry.getValue() != null && ((ArrayList)entry.getValue()).size() > 0) {
                LogHelper.debug("Culling recipe for " + ((Recipe)((ArrayList)entry.getValue()).get((int)0)).output.toString());
            }
            int depth = Recipe.cullRecipes(entry, preCullRecipes);
            if (((ArrayList)entry.getValue()).size() != 1) continue;
            Recipe addRecipe = (Recipe)((ArrayList)entry.getValue()).get(0);
            addRecipe.depth = depth;
            recipes.put((MapKey)entry.getKey(), addRecipe);
        }
    }

    private static boolean invalidStack(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || stack.field_77994_a < 1 || stack.func_77960_j() < 0;
    }

    private static void addPreCullRecipe(MapKey key, Recipe addRecipe, Map<MapKey, ArrayList<Recipe>> preCullRecipes) {
        ArrayList<Recipe> recipeList = preCullRecipes.get(key);
        if (recipeList == null) {
            recipeList = new ArrayList();
        }
        recipeList.add(addRecipe);
        preCullRecipes.put(key, recipeList);
    }

    public Recipe(ItemStack outStack, ItemStack[] componentsParam) {
        this.output = outStack;
        ItemStack[] components = new ItemStack[componentsParam.length];
        int i = 0;
        for (ItemStack itemStack : componentsParam) {
            components[i] = itemStack != null && itemStack.func_77973_b() != null ? (itemStack.func_77960_j() == Short.MAX_VALUE ? new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, 0) : new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j())) : null;
            ++i;
        }
        this.inStacks = components;
    }

    public int getOutStackSize() {
        return this.output.field_77994_a;
    }

    public static Recipe get(ItemStack output) {
        return Recipe.get(new MapKey(output));
    }

    public static Recipe get(MapKey key) {
        if (recipes.containsKey(key)) {
            return recipes.get(key);
        }
        return null;
    }

    public static Recipe get(String string) {
        return recipes.get(string);
    }

    private static int cullRecipes(Map.Entry<MapKey, ArrayList<Recipe>> entry, Map<MapKey, ArrayList<Recipe>> preCullRecipes) {
        int returnVal = 0;
        ArrayList<Recipe> value = entry.getValue();
        if (DecomposerRecipe.get(entry.getKey()) != null) {
            value.clear();
            entry.setValue(value);
            return 0;
        }
        Hashtable<Recipe, Integer> result = new Hashtable<Recipe, Integer>();
        for (Recipe check : value) {
            int depth = 0;
            if (check.inStacks != null && check.inStacks.length > 0) {
                for (ItemStack stack : check.inStacks) {
                    MapKey key;
                    if (stack != null && (depth = Math.max(depth, Recipe.getSize(key = MapKey.getKey(stack), 0, preCullRecipes))) >= 20) break;
                }
                result.put(check, depth);
                continue;
            }
            result.put(check, 20);
        }
        value.clear();
        Recipe minValue = null;
        for (Recipe key : result.keySet()) {
            if (minValue == null && (Integer)result.get(key) < 20) {
                minValue = key;
                continue;
            }
            if (minValue == null) continue;
            if (key.getOutStackSize() < minValue.getOutStackSize()) {
                minValue = key;
                continue;
            }
            if (key.getOutStackSize() != minValue.getOutStackSize() || (Integer)result.get(key) >= (Integer)result.get(minValue)) continue;
            minValue = key;
        }
        if (minValue != null) {
            returnVal = (Integer)result.get(minValue);
            value.add(minValue);
        }
        entry.setValue(value);
        return returnVal;
    }

    private static int getSize(MapKey key, int depth, Map<MapKey, ArrayList<Recipe>> preCullRecipes) {
        if (depth > 20) {
            return depth;
        }
        if (DecomposerRecipe.get(key) != null) {
            return 0;
        }
        if (!preCullRecipes.containsKey(key) || preCullRecipes.get(key).size() < 1) {
            return 1;
        }
        if (recipes.containsKey(key)) {
            return Recipe.recipes.get((Object)key).depth;
        }
        LogHelper.debug("Depth: " + depth + ", stack: " + preCullRecipes.get((Object)key).get((int)0).output.toString());
        int result = 0;
        for (Recipe recipe : preCullRecipes.get(key)) {
            int thisDepth = 0;
            for (ItemStack stack : recipe.inStacks) {
                MapKey nextKey;
                int nextDepth;
                if (stack != null && (thisDepth = Math.max(thisDepth, nextDepth = Recipe.getSize(nextKey = MapKey.getKey(stack), depth + 1, preCullRecipes))) > 20) break;
            }
            if ((result = Math.max(thisDepth, result)) <= 20) continue;
            break;
        }
        return result + 1;
    }
}

