/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.util.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;

public class ServerTickHandler {
    public static ArrayList<WeatherManagerServer> listWeatherMans;
    public static HashMap<Integer, WeatherManagerServer> lookupDimToWeatherMan;
    public static World lastWorld;
    public static NBTTagCompound worldNBT;

    public static void onTickInGame() {
        boolean debugIMC;
        if (FMLCommonHandler.instance() == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        if (world != null && lastWorld != world) {
            lastWorld = world;
        }
        if (world != null && world.func_82737_E() % (long)ConfigMisc.Misc_AutoDataSaveIntervalInTicks == 0L) {
            Weather.writeOutData(false);
        }
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WeatherManagerServer wms;
            if (!lookupDimToWeatherMan.containsKey(worlds[i].field_73011_w.field_76574_g) && WeatherUtilConfig.listDimensionsWeather.contains(worlds[i].field_73011_w.field_76574_g)) {
                ServerTickHandler.addWorldToWeather(worlds[i].field_73011_w.field_76574_g);
            }
            if ((wms = lookupDimToWeatherMan.get(worlds[i].field_73011_w.field_76574_g)) == null) continue;
            lookupDimToWeatherMan.get(worlds[i].field_73011_w.field_76574_g).tick();
        }
        boolean testRainRequest = false;
        if (testRainRequest) {
            ImmutableList listMsgs = new ArrayList();
            listMsgs = FMLInterModComms.fetchRuntimeMessages((Object)Weather.modID);
            for (int i = 0; i < listMsgs.size(); ++i) {
                if (!((FMLInterModComms.IMCMessage)listMsgs.get((int)i)).key.equals("weather.raining")) continue;
                NBTTagCompound nbt = ((FMLInterModComms.IMCMessage)listMsgs.get(i)).getNBTValue();
                String replyMod = nbt.func_74779_i("replymod");
                nbt.func_74757_a("isRaining", true);
                FMLInterModComms.sendRuntimeMessage((Object)replyMod, (String)replyMod, (String)"weather.raining", (NBTTagCompound)nbt);
            }
        }
        if (debugIMC = false) {
            try {
                ImmutableList listMsgs = new ArrayList();
                listMsgs = FMLInterModComms.fetchRuntimeMessages((Object)Weather.modID);
                for (int i = 0; i < listMsgs.size(); ++i) {
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void addWorldToWeather(int dim) {
        Weather.dbg("Registering Weather2 manager for dim: " + dim);
        WeatherManagerServer wm = new WeatherManagerServer(dim);
        listWeatherMans.add(wm);
        lookupDimToWeatherMan.put(dim, wm);
        wm.readFromFile();
    }

    public static void removeWorldFromWeather(int dim) {
        Weather.dbg("Deregistering Weather2 manager for dim: " + dim);
        WeatherManagerServer wm = lookupDimToWeatherMan.get(dim);
        if (wm != null) {
            listWeatherMans.remove(wm);
            lookupDimToWeatherMan.remove(dim);
        }
        wm.writeToFile();
    }

    public static void playerJoinedServerSyncFull(EntityPlayerMP entP) {
        WeatherManagerServer wm = lookupDimToWeatherMan.get(entP.field_70170_p.field_73011_w.field_76574_g);
        if (wm != null) {
            wm.playerJoinedServerSyncFull(entP);
        }
    }

    public static void initialize() {
        if (lookupDimToWeatherMan.get(0) == null) {
            ServerTickHandler.addWorldToWeather(0);
        }
    }

    public static void reset() {
        for (int i = 0; i < listWeatherMans.size(); ++i) {
            WeatherManagerBase wm = listWeatherMans.get(i);
            int dim = wm.dim;
            if (!lookupDimToWeatherMan.containsKey(dim)) continue;
            ServerTickHandler.removeWorldFromWeather(dim);
        }
        if (listWeatherMans.size() > 0 || lookupDimToWeatherMan.size() > 0) {
            Weather.dbg("Weather2 reset state failed to manually clear lists, listWeatherMans.size(): " + listWeatherMans.size() + " - lookupDimToWeatherMan.size(): " + lookupDimToWeatherMan.size() + " - forcing a full clear of lists");
            listWeatherMans.clear();
            lookupDimToWeatherMan.clear();
        }
    }

    static {
        worldNBT = new NBTTagCompound();
        listWeatherMans = new ArrayList();
        lookupDimToWeatherMan = new HashMap();
    }
}

