/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.pets;

import CoroUtil.pets.PetEntry;
import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PetsManager {
    public List<PetEntry> pets = new ArrayList<PetEntry>();

    public void addPet(String parOwner, EntityLiving parEnt) {
        PetEntry entry = new PetEntry();
        entry.ownerName = parOwner;
        entry.UUIDLeast = parEnt.func_110124_au().getLeastSignificantBits();
        entry.UUIDMost = parEnt.func_110124_au().getMostSignificantBits();
        entry.uUIDObj = parEnt.func_110124_au();
        this.addPetEntry(entry);
    }

    public void addPetEntry(PetEntry parEntry) {
        this.pets.add(parEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nbtReadFromDisk() {
        FileInputStream fis = null;
        try {
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroPets" + File.separator;
            File file = new File(URL2 + "tamedPets" + ".dat");
            if (file.exists()) {
                fis = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fis);
                this.nbtRead(nbttagcompound);
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void nbtWriteToDisk() {
        try {
            NBTTagCompound nbt = this.nbtWrite();
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroPets" + File.separator;
            File fl = new File(URL2);
            if (!fl.exists()) {
                fl.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(URL2 + "tamedPets" + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void nbtRead(NBTTagCompound parNBT) {
        for (String tagName : parNBT.func_150296_c()) {
            NBTTagCompound entry = parNBT.func_74775_l(tagName);
            PetEntry petEntry = new PetEntry();
            petEntry.nbtRead(entry);
            petEntry.initLoad();
            this.addPetEntry(petEntry);
        }
    }

    public NBTTagCompound nbtWrite() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.pets.size(); ++i) {
            NBTTagCompound nbtEntry = this.pets.get(i).nbtWrite();
            nbt.func_74782_a("entry_" + i, (NBTBase)nbtEntry);
        }
        return nbt;
    }

    public void reset() {
        this.pets.clear();
    }
}

