/*
 * Decompiled with CFR 0.152.
 */
package build;

import CoroUtil.packet.INBTPacketHandler;
import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import build.BuildMod;
import build.BuildServerTicks;
import build.playerdata.PlayerData;
import build.playerdata.objects.Clipboard;
import build.world.Build;
import build.world.BuildJob;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class EventHandlerPacket {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    public INBTPacketHandler getClientDataInterface() {
        if (Minecraft.func_71410_x().field_71462_r instanceof INBTPacketHandler) {
            return (INBTPacketHandler)Minecraft.func_71410_x().field_71462_r;
        }
        return null;
    }

    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            System.out.println("BuildMod packet command from server: " + command);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            System.out.println("BuildMod packet command from client: " + command);
            if (command.equals("Build_Command") && entP.field_71075_bZ.field_75098_d) {
                Clipboard cb = (Clipboard)PlayerData.get(CoroUtilEntity.getName((Entity)entP), "clipboard");
                int commandID = nbt.func_74762_e("commandID");
                int x = nbt.func_74762_e("posX");
                int y = nbt.func_74762_e("posY");
                int z = nbt.func_74762_e("posZ");
                if (commandID == 0) {
                    int sX = nbt.func_74762_e("sizeX");
                    int sY = nbt.func_74762_e("sizeY");
                    int sZ = nbt.func_74762_e("sizeZ");
                    cb.clipboardData = new Build(x, y, z, CoroUtilEntity.getName((Entity)entP) + "_clipboard", true);
                    cb.clipboardData.dim = entP.field_70170_p.field_73011_w.field_76574_g;
                    cb.clipboardData.setCornerPosition(x, y, z);
                    cb.clipboardData.map_sizeX = sX;
                    cb.clipboardData.map_sizeY = sY;
                    cb.clipboardData.map_sizeZ = sZ;
                    cb.clipboardData.scanLevelToData();
                    System.out.println("copy: " + x + ", " + y + ", " + z + ", " + sX + ", " + sY + ", " + sZ);
                } else {
                    int dir = nbt.func_74762_e("direction");
                    cb.clipboardData.setCornerPosition(x, y, z);
                    cb.clipboardData.dim = entP.field_70170_p.field_73011_w.field_76574_g;
                    BuildJob bj = new BuildJob(BuildServerTicks.buildMan.activeBuilds.size(), cb.clipboardData);
                    bj.setDirection(dir);
                    System.out.println("build: " + x + ", " + y + ", " + z + ", dir:" + bj.direction);
                    bj.useRotationBuild = true;
                    bj.useFirstPass = false;
                    bj.build_rate = 100;
                    BuildServerTicks.buildMan.addBuild(bj);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static FMLProxyPacket getBuildCommandPacket(Build build, int commandID, int direction) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "Build_Command");
        data.func_74768_a("commandID", commandID);
        data.func_74768_a("posX", build.map_coord_minX);
        data.func_74768_a("posY", build.map_coord_minY);
        data.func_74768_a("posZ", build.map_coord_minZ);
        if (commandID == 0) {
            data.func_74768_a("sizeX", build.map_sizeX);
            data.func_74768_a("sizeY", build.map_sizeY);
            data.func_74768_a("sizeZ", build.map_sizeZ);
        } else {
            data.func_74768_a("direction", direction);
        }
        return PacketHelper.getNBTPacket(data, BuildMod.eventChannelName);
    }
}

