/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.particle.entity.EntityIconFX;
import extendedrenderer.particle.entity.EntityIconWindFX;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ParticleBehaviors {
    public List<EntityRotFX> particles = new ArrayList<EntityRotFX>();
    public Vec3 coordSource;
    public Entity sourceEntity = null;
    public Random rand = new Random();
    public float rateDarken = 0.025f;
    public float rateBrighten = 0.01f;
    public float rateBrightenSlower = 0.003f;
    public float rateAlpha = 0.002f;
    public float rateScale = 0.1f;
    public int tickSmokifyTrigger = 40;

    public ParticleBehaviors(Vec3 source) {
        this.coordSource = source;
    }

    public void tickUpdateList() {
        for (int i = 0; i < this.particles.size(); ++i) {
            EntityRotFX particle = this.particles.get(i);
            if (particle.field_70128_L) {
                this.particles.remove((Object)particle);
                continue;
            }
            this.tickUpdate(particle);
        }
    }

    public void tickUpdate(EntityRotFX particle) {
        if (this.sourceEntity != null) {
            this.coordSource = Vec3.func_72443_a((double)this.sourceEntity.field_70165_t, (double)this.sourceEntity.field_70163_u, (double)this.sourceEntity.field_70161_v);
        }
        this.tickUpdateAct(particle);
    }

    public void tickUpdateAct(EntityRotFX particle) {
        double centerX = particle.field_70165_t;
        double centerZ = particle.field_70161_v;
        if (this.coordSource != null) {
            centerX = this.coordSource.field_72450_a;
            centerZ = this.coordSource.field_72449_c;
        }
        double vecX = centerX - particle.field_70165_t;
        double vecZ = centerZ - particle.field_70161_v;
        double distToCenter = Math.sqrt(vecX * vecX + vecZ * vecZ);
        double rotYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
        double adjYaw = Math.min(360, 45 + particle.getAge());
        rotYaw -= adjYaw;
        double speed = 0.1;
        if (particle.getAge() < 25 && distToCenter > 0.05) {
            particle.field_70159_w = Math.cos(rotYaw * 0.017453) * speed;
            particle.field_70179_y = Math.sin(rotYaw * 0.017453) * speed;
        } else {
            double speed2 = 0.008;
            double pSpeed = Math.sqrt(particle.field_70159_w * particle.field_70159_w + particle.field_70179_y * particle.field_70179_y);
            if (pSpeed < 0.2 && particle.field_70181_x < 0.01) {
                speed2 = 0.08;
            }
            if (pSpeed < 0.002 && Math.abs(particle.field_70181_x) < 0.02) {
                particle.field_70181_x -= 0.15;
            }
            particle.field_70159_w += (this.rand.nextDouble() - this.rand.nextDouble()) * speed2;
            particle.field_70179_y += (this.rand.nextDouble() - this.rand.nextDouble()) * speed2;
        }
        float brightnessShiftRate = this.rateDarken;
        int stateChangeTick = this.tickSmokifyTrigger;
        if (particle.getAge() < stateChangeTick) {
            particle.setGravity(-0.2f);
            particle.func_70538_b(particle.func_70534_d() - brightnessShiftRate, particle.func_70542_f() - brightnessShiftRate, particle.func_70535_g() - brightnessShiftRate);
        } else if (particle.getAge() == stateChangeTick) {
            particle.func_70538_b(0.0f, 0.0f, 0.0f);
        } else {
            brightnessShiftRate = this.rateBrighten;
            particle.setGravity(-0.05f);
            if (!(particle.func_70534_d() < 0.3f)) {
                brightnessShiftRate = this.rateBrightenSlower;
            }
            particle.func_70538_b(particle.func_70534_d() + brightnessShiftRate, particle.func_70542_f() + brightnessShiftRate, particle.func_70535_g() + brightnessShiftRate);
            if (particle.getAlphaF() > 0.0f) {
                particle.func_82338_g(particle.getAlphaF() - this.rateAlpha);
            } else {
                particle.func_70106_y();
            }
        }
        if (particle.getScale() < 8.0f) {
            particle.setScale(particle.getScale() + this.rateScale);
        }
    }

    public void tickUpdateCloud(EntityRotFX particle) {
        particle.field_70177_z = (float)((double)particle.field_70177_z - 0.1);
        int ticksFadeInMax = 100;
        if (particle.getAge() < ticksFadeInMax) {
            particle.func_82338_g((float)particle.getAge() * 0.01f);
        } else if (particle.getAlphaF() > 0.0f) {
            particle.func_82338_g(particle.getAlphaF() - this.rateAlpha * 1.3f);
        } else {
            particle.func_70106_y();
        }
    }

    public EntityRotFX spawnNewParticleWindFX(World world, IIcon icon, double x, double y, double z, double vecX, double vecY, double vecZ) {
        EntityIconWindFX entityfx = new EntityIconWindFX(world, x, y, z, vecX, vecY, vecZ, icon);
        entityfx.pb = this;
        return entityfx;
    }

    public EntityRotFX spawnNewParticleIconFX(World world, IIcon icon, double x, double y, double z, double vecX, double vecY, double vecZ) {
        return this.spawnNewParticleIconFX(world, icon, x, y, z, vecX, vecY, vecZ, -1);
    }

    public EntityRotFX spawnNewParticleIconFX(World world, IIcon icon, double x, double y, double z, double vecX, double vecY, double vecZ, int renderOrder) {
        EntityIconFX entityfx = new EntityIconFX(world, x, y, z, vecX, vecY, vecZ, icon);
        entityfx.pb = this;
        entityfx.renderOrder = renderOrder;
        return entityfx;
    }

    public EntityRotFX initParticle(EntityRotFX particle) {
        particle.field_70169_q = particle.field_70165_t;
        particle.field_70167_r = particle.field_70163_u;
        particle.field_70166_s = particle.field_70161_v;
        particle.field_70142_S = particle.field_70165_t;
        particle.field_70137_T = particle.field_70163_u;
        particle.field_70136_U = particle.field_70161_v;
        particle.func_70105_a(0.01f, 0.01f);
        return particle;
    }

    public static EntityRotFX setParticleRandoms(EntityRotFX particle, boolean yaw, boolean pitch) {
        Random rand = new Random();
        if (yaw) {
            particle.field_70177_z = rand.nextInt(360);
        }
        if (pitch) {
            particle.field_70125_A = rand.nextInt(360);
        }
        return particle;
    }

    public static EntityRotFX setParticleFire(EntityRotFX particle) {
        Random rand = new Random();
        particle.func_70538_b(0.6f + rand.nextFloat() * 0.4f, 0.2f + rand.nextFloat() * 0.2f, 0.0f);
        particle.setScale(0.25f + 0.2f * rand.nextFloat());
        particle.brightness = 1.0f;
        particle.func_70105_a(0.1f, 0.1f);
        particle.func_82338_g(0.6f);
        return particle;
    }

    public static EntityRotFX setParticleCloud(EntityRotFX particle, float freezeY) {
        particle.spawnY = freezeY;
        particle.field_70125_A = 90.0f;
        particle.field_70155_l = 999.0;
        particle.field_70145_X = true;
        particle.func_70105_a(0.25f, 0.25f);
        particle.setScale(500.0f);
        particle.callUpdateSuper = false;
        particle.callUpdatePB = false;
        particle.setMaxAge(500);
        particle.func_70538_b(1.0f, 1.0f, 1.0f);
        particle.brightness = 0.3f;
        particle.renderRange = 999.0f;
        particle.func_82338_g(0.0f);
        return particle;
    }

    public void cleanup() {
    }
}

